% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassSangerRead.R
\docType{class}
\name{SangerRead-class}
\alias{SangerRead-class}
\title{SangerRead}
\description{
An S4 class extending sangerseq S4 class which corresponds to a single ABIF file in Sanger sequencing.
}
\section{Slots}{

\describe{
\item{\code{objectResults}}{This is the object that stores all information of the creation result.}

\item{\code{inputSource}}{The input source of the raw file. It must be \code{"ABIF"} or \code{"FASTA"}. The default value is \code{"ABIF"}.}

\item{\code{readFeature}}{The direction of the Sanger read. The value must be \code{"Forward Read"} or \code{"Reverse Read"}.}

\item{\code{readFileName}}{The filename of the target input file.}

\item{\code{fastaReadName}}{If \code{inputSource} is \code{"FASTA"}, then this value has to be the name of the read inside the FASTA file; if \code{inputSource} is \code{"ABIF"}, then this value is \code{NULL} by default.}

\item{\code{geneticCode}}{Named character vector in the same format as \code{GENETIC_CODE} (the default), which represents the standard genetic code. This is the code with which the function will attempt to translate your DNA sequences. You can get an appropriate vector with the getGeneticCode() function. The default is the standard code.}

\item{\code{abifRawData}}{An S4 class containing all fields in the ABIF file. It is the abif class defined in sangerseqR package.}

\item{\code{QualityReport}}{A S4 class containing quality trimming related inputs and trimming results.}

\item{\code{ChromatogramParam}}{A S4 class containing chromatogram inputs.}

\item{\code{primaryAASeqS1}}{A polypeptide translated from primary DNA sequence starting from the first nucleic acid.}

\item{\code{primaryAASeqS2}}{A polypeptide translated from primary DNA sequence starting from the second nucleic acid.}

\item{\code{primaryAASeqS3}}{A polypeptide translated from primary DNA sequence starting from the third nucleic acid.}

\item{\code{primarySeqRaw}}{The raw primary sequence from sangerseq class in sangerseqR package before base calling.}

\item{\code{secondarySeqRaw}}{The raw secondary sequence from sangerseq class in sangerseqR package before base calling.}

\item{\code{peakPosMatrixRaw}}{The raw peak position matrix from sangerseq class in sangerseqR package before base calling.}

\item{\code{peakAmpMatrixRaw}}{The raw peak amplitude matrix from sangerseq class in sangerseqR package before base calling.}
}}

\examples{
## Simple example
inputFilesPath <- system.file("extdata/", package = "sangeranalyseR")
A_chloroticaFFN <- file.path(inputFilesPath,
                             "Allolobophora_chlorotica",
                             "ACHLO",
                             "Achl_ACHLO006-09_1_F.ab1")
sangerReadF <- new("SangerRead",
                    readFeature           = "Forward Read",
                    readFileName          = A_chloroticaFFN)
                          
## Input From ABIF file format
# Forward Read
A_chloroticaFFN <- file.path(inputFilesPath,
                             "Allolobophora_chlorotica",
                             "ACHLO",
                             "Achl_ACHLO006-09_1_F.ab1")
sangerReadF <- new("SangerRead",
                    printLevel            = "SangerRead",
                    inputSource           = "ABIF",
                    readFeature           = "Forward Read",
                    readFileName          = A_chloroticaFFN,
                    fastaReadName         = NULL,
                    geneticCode           = GENETIC_CODE,
                    TrimmingMethod        = "M1",
                    M1TrimmingCutoff      = 0.0001,
                    M2CutoffQualityScore  = NULL,
                    M2SlidingWindowSize   = NULL,
                    baseNumPerRow         = 100,
                    heightPerRow          = 200,
                    signalRatioCutoff     = 0.33,
                    showTrimmed           = TRUE)

# Reverse Read
A_chloroticaRFN <- file.path(inputFilesPath,
                             "Allolobophora_chlorotica",
                             "ACHLO",
                             "Achl_ACHLO006-09_2_R.ab1")
sangerReadR <- new("SangerRead",
                    inputSource           = "ABIF",
                    readFeature           = "Reverse Read",
                    readFileName          = A_chloroticaRFN,
                    geneticCode           = GENETIC_CODE,
                    TrimmingMethod        = "M1",
                    M1TrimmingCutoff      = 0.0001,
                    M2CutoffQualityScore  = NULL,
                    M2SlidingWindowSize   = NULL,
                    baseNumPerRow         = 100,
                    heightPerRow          = 200,
                    signalRatioCutoff     = 0.33,
                    showTrimmed           = TRUE)


## Input From FASTA file format
# Forward Read
inputFilesPath <- system.file("extdata/", package = "sangeranalyseR")
A_chloroticaFFNfa <- file.path(inputFilesPath,
                               "fasta",
                               "SangerRead",
                               "Achl_ACHLO006-09_1_F.fa")
readNameFfa <- "Achl_ACHLO006-09_1_F"
sangerReadFfa <- new("SangerRead",
                     inputSource        = "FASTA",
                     readFeature        = "Forward Read",
                     readFileName       = A_chloroticaFFNfa,
                     fastaReadName      = readNameFfa,
                     geneticCode        = GENETIC_CODE)
# Reverse Read
A_chloroticaRFNfa <- file.path(inputFilesPath,
                               "fasta",
                               "SangerRead",
                               "Achl_ACHLO006-09_2_R.fa")
readNameRfa <- "Achl_ACHLO006-09_2_R"
sangerReadRfa <- new("SangerRead",
                     inputSource   = "FASTA",
                     readFeature   = "Reverse Read",
                     readFileName  = A_chloroticaRFNfa,
                     fastaReadName = readNameRfa,
                     geneticCode   = GENETIC_CODE)
}
\author{
Kuan-Hao Chao
}
