% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quietVDJgenes.R
\name{quietVDJgenes}
\alias{quietVDJgenes}
\alias{quietTCRgenes}
\alias{quietTCRgenes.default}
\alias{quietTCRgenes.Seurat}
\alias{quietBCRgenes}
\alias{quietBCRgenes.default}
\alias{quietBCRgenes.Seurat}
\title{Remove TCR and BCR genes from variable gene results}
\usage{
quietVDJgenes(input.data, ...)

quietTCRgenes(input.data, ...)

\method{quietTCRgenes}{default}(input.data, ...)

\method{quietTCRgenes}{Seurat}(input.data, assay = NULL, ...)

quietBCRgenes(input.data, ...)

\method{quietBCRgenes}{default}(input.data, ...)

\method{quietBCRgenes}{Seurat}(input.data, assay = NULL, ...)
}
\arguments{
\item{input.data}{Single-cell object in Seurat format or vector of variable genes
to use in reduction}

\item{...}{Reserved for future arguments}

\item{assay}{The Seurat assay slot to use to remove immune receptor genes
from, NULL value will default to the default assay}
}
\value{
Seurat object or vector list with TCR genes removed.
}
\description{
Most single-cell workflows use highly-expressed and highly-variable
genes for the initial calculation of PCA and subsequent dimensional
reduction. This function will remove the TCR and/or BCR genes from the
variable features in a Seurat object or from a vector (potentially
generated by the Bioconductor scran workflow).
}
\examples{
example <- quietVDJgenes(scRep_example)
scRep <- quietTCRgenes(scRep_example)
ibex_example <- quietBCRgenes(scRep_example)

}
\author{
Nicky de Vrij, Nikolaj Pagh, Nick Borcherding, Qile Yang
}
