% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findEcdfsCell.R
\name{findEcdfsCell}
\alias{findEcdfsCell}
\title{Construct empirical cumulative distribution functions (ecdfs) for within-cell distances}
\usage{
findEcdfsCell(p, owins, nPointsAllWin, centroids, null, pis, loopFun)
}
\arguments{
\item{p}{The point pattern}

\item{owins, centroids}{The list of windows corresponding to cells,
and their centroids}

\item{nPointsAllWin}{How many points to subsample or simulate
to calculate distance to cell edge or centroid distribution}

\item{null}{A character vector, indicating how the null distribution is
defined. See details of \link{estPis}.}

\item{pis}{The PIs to be estimated or for which weighting functions is to be added}

\item{loopFun}{The function to use to loop over the features.
Defaults to bplapply except when looping over features within cells}
}
\value{
The list of ecdf functions
}
\description{
The distance distribution under the null hypothesis of complete spatial randomness (CSR)
within the cell is the same for all genes. This function precalculates this distribution using Monte-Carlo simulation under CSR,
and summarizes it in an ecdf object
}
\seealso{
\link{ecdf}
}
