% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLMMs.R
\name{lm_from_wfit}
\alias{lm_from_wfit}
\title{Add compoments to a result from lm.wfit to make it a minimally valid lm object}
\usage{
lm_from_wfit(obj, y, Terms, Assign)
}
\arguments{
\item{obj}{The lm.wfit() result}

\item{y}{the outcome variable}

\item{Terms, Assign}{Added to the object}
}
\value{
A object of class lm
}
\description{
Add compoments to a result from lm.wfit to make it a minimally valid lm object
}
\examples{
n <- 7 ; p <- 2
X <- matrix(rnorm(n * p), n, p) # no intercept!
y <- rnorm(n)
w <- rnorm(n)^2
lmw <- lm.wfit(x = X, y = y, w = w)
lmObject <- lm_from_wfit(lmw, y = y, Terms = terms(Y~X), 
Assign = attr(model.matrix(~X), "assign"))
summary(lmObject)
anova(lmObject)
}
