% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_similarity_searches.R
\name{collapse_bidirectional_hits}
\alias{collapse_bidirectional_hits}
\title{Collapse a list of bidirectional DIAMOND hits}
\usage{
collapse_bidirectional_hits(blast_inter, compare)
}
\arguments{
\item{blast_inter}{A list of data frames containing BLAST/DIAMOND tables
with comparisons between target species and outgroups.
BLASTp, DIAMOND, or similar programs must be run on processed sequence data
as returned by \code{syntenet::process_input()}.}

\item{compare}{A 2-column data frame with target species name in column 1,
and outgroup species name in column 2. Species names must match names of
list elements in \strong{blast_inter}.}
}
\value{
A list of data frames with BLAST/DIAMOND tables as
in \strong{blast_inter}, but with bidirectional hits combined. For instance,
if \strong{blast_inter} contains elements 'spA_spB' and 'spB_spA', these
two data frames are combined into a single data frame following the
order indicated in \strong{outgroups} (i.e. 'column1_column2').
}
\description{
Collapse a list of bidirectional DIAMOND hits
}
\examples{
data(blast_list)
blast_inter <- blast_list[c(2,3)]
compare <- data.frame(species = "Olucimarinus", outgroup = "OspRCC809")
chits <- collapse_bidirectional_hits(blast_inter, compare)
}
