% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_synteny.R
\name{intraspecies_synteny}
\alias{intraspecies_synteny}
\title{Detect intraspecies synteny}
\usage{
intraspecies_synteny(
  blast_intra = NULL,
  annotation = NULL,
  intra_dir = file.path(tempdir(), "intra"),
  anchors = 5,
  max_gaps = 25,
  is_pairwise = TRUE,
  verbose = FALSE,
  bp_param = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{blast_intra}{A list of BLAST/DIAMOND data frames for
intraspecies comparisons as returned by \code{run_diamond()}.}

\item{annotation}{A processed GRangesList or CompressedGRangesList object
as returned by \code{process_input()}.}

\item{intra_dir}{Path to output directory where .collinearity files will
be stored.}

\item{anchors}{Numeric indicating the minimum required number of genes
to call a syntenic block. Default: 5.}

\item{max_gaps}{Numeric indicating the number of upstream and downstream
genes to search for anchors. Default: 25.}

\item{is_pairwise}{Logical indicating if only pairwise blocks should be
reported. Default: TRUE.}

\item{verbose}{Logical indicating if log messages should be printed on
screen. Default: FALSE.}

\item{bp_param}{BiocParallel back-end to be used.
Default: \code{BiocParallel::SerialParam()}.}

\item{...}{Any additional arguments to the \code{MCScanX} algorithm. For a
complete list of all available options, see the man page
of \code{rcpp_mcscanx_file()}.}
}
\value{
Paths to .collinearity files.
}
\description{
Detect intraspecies synteny
}
\examples{
# Load data
data(scerevisiae_annot)
data(scerevisiae_diamond)

# Detect intragenome synteny
intra_syn <- intraspecies_synteny(
    scerevisiae_diamond, scerevisiae_annot
)

}
