% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{rename}
\alias{rename}
\title{Rename columns}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Rows are not affected.
\item Column names are changed; column order is preserved.
\item Data frame attributes are preserved.
\item Groups are updated to reflect new names.
}
}
\description{
\code{rename()} changes the names of individual variables using
\code{new_name = old_name} syntax; \code{rename_with()} renames columns using a
function.
}
\section{Methods}{


This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("rename")}.

}

\examples{
example(read10xVisium)
spe |>
    rename(in_liver = in_tissue)
}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{mutate}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
