% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgerWrp.R
\name{edgerWrp}
\alias{edgerWrp}
\title{Wrapper applying an edgeR differential analysis workflow}
\usage{
edgerWrp(
  count,
  lib_size = NULL,
  option = c("glm", "glmQL"),
  design,
  contrast = NULL,
  normalize = TRUE,
  normalize_method = "TMM",
  ...
)
}
\arguments{
\item{count}{A matrix with features (e.g., genes or microbes) in rows and
samples in columns.}

\item{lib_size}{A numeric vector with library sizes for each sample. If
\code{NULL} (default), the column sums of \code{count} are used.}

\item{option}{Either \code{"glm"} or \code{"glmQL"}. If \code{"glm"},
\code{\link[edgeR]{glmFit}} and \code{\link[edgeR]{glmLRT}} are used;
otherwise, \code{\link[edgeR]{glmQLFit}} and
\code{\link[edgeR]{glmQLFTest}} are used. Details about the difference
between the two options can be found in the help pages of
\code{\link[edgeR]{glmQLFit}}.}

\item{design}{A numeric design matrix, e.g. created by
\code{\link[stats]{model.matrix}}. Please refer to \code{design} in
\code{\link[edgeR]{glmQLFit}} and \code{\link[edgeR]{glmFit}} for
more details.}

\item{contrast}{A numeric vector specifying one contrast of
the linear model coefficients to be tested. Its length
must equal the number of columns of \code{design}. If \code{NULL}, the
last coefficient will be tested. Please refer to \code{contrast}
in \code{\link[edgeR]{glmQLFTest}} and \code{\link[edgeR]{glmLRT}} for
more details.}

\item{normalize}{A logical scalar, specifying whether normalization factors
should be calculated (using \code{\link[edgeR]{calcNormFactors}}).}

\item{normalize_method}{Normalization method to be used. Please refer to
\code{method} in \code{\link[edgeR]{calcNormFactors}} for more details.}

\item{...}{More arguments to pass to \code{\link[edgeR]{glmFit}}
(if \code{option = "glm"} or \code{\link[edgeR]{glmQLFit}}
(if \code{option = "glmQL"}).}
}
\value{
The output of \code{\link[edgeR]{glmQLFTest}} or
\code{\link[edgeR]{glmLRT}} depending on the specified \code{option}.
}
\description{
\code{edgerWrp} is a wrapper using functions from the
\code{\link[edgeR:edgeR-package]{edgeR}} package (Robinson et al. 2010,
\emph{Bioinformatics}; McCarthy et al. 2012, \emph{Nucleic Acids Research})
to fit models and perform a moderated test for each entity.
}
\details{
The function performs the following steps:
\itemize{
\item Create a \code{\link[edgeR]{DGEList}} object. If \code{lib_size} is
given, set the library sizes to these values, otherwise use the column sums
of the count matrix.
\item If \code{normalize} is \code{TRUE}, estimate normalization factors
using \code{\link[edgeR]{calcNormFactors}}.
\item Estimate dispersions with \code{\link[edgeR]{estimateDisp}}.
\item Depending on the value of \code{option}, apply either the LRT or
QLF edgeR workflows (i.e., either \code{\link[edgeR]{glmFit}} +
\code{\link[edgeR]{glmLRT}} or \code{\link[edgeR]{glmQLFit}} +
\code{\link[edgeR]{glmQLFTest}}), testing for the specified contrast.
}
}
\examples{
suppressPackageStartupMessages({
    library(TreeSummarizedExperiment)
})
## Read example data
x <- readRDS(system.file("extdata/da_sim_100_30_18de.rds",
                         package = "treeclimbR"))

## Run differential abundance analysis
out <- edgerWrp(count = assay(x), option = "glm",
                design = model.matrix(~ group, data = colData(x)),
                contrast = c(0, 1))

## The output is an edgeR DGELRT object
class(out)

}
\author{
Ruizhu Huang
}
