% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parEstimate.R
\name{parEstimate}
\alias{parEstimate}
\title{Parameter estimation for Dirichlet-multinomial distribution}
\usage{
parEstimate(obj, assay = NULL)
}
\arguments{
\item{obj}{A matrix or \code{TreeSummarizedExperiment}, with samples in the
columns and entities in the rows.}

\item{assay}{If \code{obj} is a \code{TreeSummarizedExperiment}, the name
or index of the assay to use to estimate Dirichlet multinomial
parameters. If \code{NULL}, the first assay will be used.}
}
\value{
A list including the estimates of \code{pi} (a vector with one
element per row in \code{obj}) and \code{theta} (a scalar).
}
\description{
\code{parEstimate} is a wrapper of the function
\code{\link[dirmult]{dirmult}} with default settings for \code{init},
\code{initscalar}, \code{epsilon}, \code{trace} and \code{mode}. It allows
the input \code{obj} to be either a \code{matrix} or a
\code{TreeSummarizedExperiment} and outputs the estimated values of
\code{pi} and \code{theta}.
}
\examples{
suppressPackageStartupMessages({
    library(TreeSummarizedExperiment)
})

set.seed(1L)
y <- matrix(rnbinom(200, size = 1, mu = 10), nrow = 10)
colnames(y) <- paste("S", seq_len(20), sep = "")
rownames(y) <- tinyTree$tip.label
toy_tse <- TreeSummarizedExperiment(rowTree = tinyTree,
                                    assays = list(y))
res <- parEstimate(obj = toy_tse)
metadata(res)$assays.par

}
\author{
Ruizhu Huang, Charlotte Soneson
}
