% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotVarPart}
\alias{plotVarPart}
\alias{plotVarPart,matrix-method}
\alias{plotVarPart,data.frame-method}
\alias{plotVarPart,varPartResults-method}
\title{Violin plot of variance fractions}
\usage{
plotVarPart(
  obj,
  col = c(ggColorHue(ncol(obj) - 1), "grey85"),
  label.angle = 20,
  main = "",
  ylab = "",
  convertToPercent = TRUE,
  ...
)

\S4method{plotVarPart}{matrix}(
  obj,
  col = c(ggColorHue(ncol(obj) - 1), "grey85"),
  label.angle = 20,
  main = "",
  ylab = "",
  convertToPercent = TRUE,
  ...
)

\S4method{plotVarPart}{data.frame}(
  obj,
  col = c(ggColorHue(ncol(obj) - 1), "grey85"),
  label.angle = 20,
  main = "",
  ylab = "",
  convertToPercent = TRUE,
  ...
)

\S4method{plotVarPart}{varPartResults}(
  obj,
  col = c(ggColorHue(ncol(obj) - 1), "grey85"),
  label.angle = 20,
  main = "",
  ylab = "",
  convertToPercent = TRUE,
  ...
)
}
\arguments{
\item{obj}{\code{varParFrac} object returned by \code{fitExtractVarPart} or \code{extractVarPart}}

\item{col}{vector of colors}

\item{label.angle}{angle of labels on x-axis}

\item{main}{title of plot}

\item{ylab}{text on y-axis}

\item{convertToPercent}{multiply fractions by 100 to convert to percent values}

\item{...}{additional arguments}
}
\value{
Makes violin plots of variance components model.  This function uses the graphics interface from ggplot2.  Warnings produced by this function usually ggplot2 warning that the window is too small.
}
\description{
Violin plot of variance fraction for each gene and each variable
}
\examples{

# load library
# library(variancePartition)

library(BiocParallel)

# load simulated data:
# geneExpr: matrix of gene expression values
# info: information/metadata about each sample
data(varPartData)

# Specify variables to consider
# Age is continuous so we model it as a fixed effect
# Individual and Tissue are both categorical, so we model them as random effects
form <- ~ Age + (1 | Individual) + (1 | Tissue)

varPart <- fitExtractVarPartModel(geneExpr, form, info)

# violin plot of contribution of each variable to total variance
plotVarPart(sortCols(varPart))

}
