% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_features.R
\name{adjust_node}
\alias{adjust_node}
\title{Adjust two batches to each other.}
\usage{
adjust_node(data, b1, b2, mod, combatmode, method)
}
\arguments{
\item{data}{Matrix or dataframe in the format (samples, features).
Additional column names are "Batch", "Cov_X" (were X may be any number),
"Label" and "Sample".}

\item{b1}{The first batch to adjust.}

\item{b2}{The second batch to adjust.}

\item{mod}{Dataframe with potential covariables to use. May be emty.}

\item{combatmode}{Integer, encoding the parameters to use for ComBat.
1 (default)    par.prior = TRUE, mean.only = FALSE
2              par.prior = TRUE, mean.only = TRUE
3              par.prior = FALSE, mean.only = FALSE
4              par.prior = FALSE, mean.only = TRUE
Will be ignored, if method=="limma".}

\item{method}{Adjustment method to use. Should either be "ComBat" or "limma".
"None" is also allowed for testing purposes and will yield no batch effect
correction.}
}
\value{
A matrix/dataframe mirroring the shape of the input. The data will
be batch-effect adjusted by the specified method.
}
\description{
This function is called by the BERT algorithm and should not be called by
the user directly.
}
