% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_ratios.R
\name{ratio_plotter}
\alias{ratio_plotter}
\title{This function allows you to plot ratios of explained variation}
\usage{
ratio_plotter(ev_ratio)
}
\arguments{
\item{ev_ratio}{table of ratios from variation_ratios()}
}
\value{
boxplot of ratios
}
\description{
This function allows you to plot ratios of explained variation
}
\examples{
library(scran)
se <- mockSCE()
se$Mutation_Status <- as.factor(se$Mutation_Status)
se$Treatment <- as.factor(se$Treatment)
expl_var_result <- batchqc_explained_variation(se, batch = "Mutation_Status",
                            condition = "Treatment", assay_name = "counts")
ratios_results <- variation_ratios(expl_var_result[[1]],
    batch = "Mutation_Status")
ratio_boxplot <- BatchQC::ratio_plotter(ratios_results)
ratio_boxplot

}
