% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareTranscriptome.R
\name{merge_transcriptome_and_intergenic}
\alias{merge_transcriptome_and_intergenic}
\title{Merge transcriptome file provided by the user with the Bgee intergenic 
fasta file.}
\usage{
merge_transcriptome_and_intergenic(
  myKallistoMetadata,
  myBgeeMetadata,
  myUserMetadata
)
}
\arguments{
\item{myKallistoMetadata}{A Reference Class KallistoMetadata object.}

\item{myBgeeMetadata}{A Reference Class BgeeMetadata object.}

\item{myUserMetadata}{A Reference Class UserMetadata object.}
}
\value{
save merged file on the hard drive
}
\description{
This function will create a file corresponding to the concatenation 
of the transcriptome fasta file provided by the user and the corresponding 
intergenic fasta file created by Bgee.
}
\examples{
{
bgee <- new('BgeeMetadata', intergenic_release = '0.1')
user <- new ('UserMetadata', species_id = '6239')
kallisto <- new('KallistoMetadata')
user <- setTranscriptomeFromFile(user, system.file("extdata", 
"transcriptome.fa", package = "BgeeCall"), 'WBcel235')
merge_transcriptome_and_intergenic(kallisto, bgee, user)
}

}
\author{
Julien Wollbrett.
}
