% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{calculateSignalToFlankScore}
\alias{calculateSignalToFlankScore}
\title{Calculate signal-to-flank score}
\usage{
calculateSignalToFlankScore(
  object,
  flank = c("bs", "manual"),
  flank.size = NULL,
  quiet = FALSE
)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{flank}{character; how the flanking region shoule be set. Options are
'bs', 'manual'}

\item{flank.size}{numeric; if flank='manual' provide the desired flanking size}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class \code{\link{BSFDataSet}} with signal-to-flank ratios
added to the meta column of the ranges.
}
\description{
This function calculates the signal-to-flank ratio for all present binding
sites.
}
\details{
Each input range is treated as a binding site. For a particular binding site
all overlapping crosslinks are summed up and divided by the normalized sum of
the crosslinks in the two adjecent regions of the same size. This is done
for all bining sites and the ratio is reported as a score.

The function is part of the standard workflow performed by \code{\link{BSFind}}.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds = makeBindingSites(bds, bsSize = 5)
bds = calculateSignalToFlankScore(bds)

}
\seealso{
\code{\link{BSFind}}, \code{\link{bindingSiteDefinednessPlot}}
}
