% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialFunctions.R
\name{imputeBsDifferencesForTestdata}
\alias{imputeBsDifferencesForTestdata}
\title{Impute artificial differences in the example data set}
\usage{
imputeBsDifferencesForTestdata(object, size = 5, change.per = 0.1)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object; explicitly the test data set
from the extdata folder}

\item{size}{numeric; the number of positions on which signal should be
deleted, counting from the start}

\item{change.per}{numeric; the percentage of ranges that should be effected
by the change.}
}
\value{
object a \code{\link{BSFDataSet}} object with the signal slot adapted
to reflect changes in binding between two artificial conditions
}
\description{
A function that works only on the test data set provided with the package. It
is used for internal testing and the making of examples to showcase the
differential binding functions.
}
\details{
Differences between samples are artificially introduced by removing the
signal on a random set of binding sites of the input.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])

bds = makeBindingSites(bds, bsSize = 7)
bds = assignToGenes(bds, anno.genes = gns)

bds = imputeBsDifferencesForTestdata(bds)

}
