% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{mergeCrosslinkDiagnosticsPlot}
\alias{mergeCrosslinkDiagnosticsPlot}
\title{Plot binding site merging diagnostics}
\usage{
mergeCrosslinkDiagnosticsPlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the number of regions to merge over the width
of these regions for each merging iteration calculated in
\code{\link{makeBindingSites}}. The function \code{\link{makeBindingSites}}
is expected to be executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds = makeBindingSites(object = bds, bsSize = 9)
mergeCrosslinkDiagnosticsPlot(bds)

}
\seealso{
\code{\link{makeBindingSites}}
}
