% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialPlots.R
\name{plotBsVolcano}
\alias{plotBsVolcano}
\title{Volcano style plot}
\usage{
plotBsVolcano(object, what = c("bs", "bg"), sig.threshold = 0.05)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with results calculated by
\code{\link{calculateBsFoldChange}}}

\item{what}{character; whether to show results for binding sites or the
background (one of: 'bs', 'bg')}

\item{sig.threshold}{numeric; what P value significance level to use
(default = 0.05)}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
Wrapper that plots differential binding results as volcano plot. For each binding
site the estimated fold-change (log2) is shown on X and the adjusted
P value (-log10) is shown on Y.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])

# make testset
bds = makeBindingSites(bds, bsSize = 7)
bds = assignToGenes(bds, anno.genes = gns)
bds = imputeBsDifferencesForTestdata(bds)
bds = calculateBsBackground(bds, anno.genes = gns, use.offset = FALSE)

# use all filters and remove binding sites that fail (default settings)
bds = filterBsBackground(bds)

# calculate fold-changes
bds = calculateBsFoldChange(bds)

# make volcano plot
plotBsVolcano(bds)

}
\seealso{
\code{\link{calculateBsFoldChange}}
}
