% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseasePairs.R
\name{sampleDegBinnedGDA}
\alias{sampleDegBinnedGDA}
\title{Function to randomly shuffle vertex annotation terms, whilst preserving the
vertex degree originally found with that annotation term..}
\usage{
sampleDegBinnedGDA(org.map, term)
}
\arguments{
\item{org.map}{degree-annotation mapping returned by
\code{\link{degreeBinnedGDAs}}}

\item{term}{annotation term to shuffle}
}
\value{
vertex IDs to assign \code{term} in shuffled annotation
}
\description{
Function to randomly shuffle vertex annotation terms, whilst preserving the
vertex degree originally found with that annotation term..
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
agg<-annotateGeneNames(gg)
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(agg)$name == '80273')
paste(V(agg)$GeneName[idx], 'GRPEL1')
gda<-prepareGDA(agg, 'TopOntoOVGHDOID')
diseases<-getAnnotationList(gda)
m<-degreeBinnedGDAs(agg, gda, diseases)
sampleDegBinnedGDA(m, diseases[1])
}
\seealso{
degreeBinnedGDAs
}
