% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{get_neighbors}
\alias{get_neighbors}
\title{Get 1st-order neighbors of a given gene or group of genes}
\usage{
get_neighbors(genes, net, cor_threshold = 0.7)
}
\arguments{
\item{genes}{Character vector containing genes from which
direct neighbors will be extracted.}

\item{net}{List object returned by \code{exp2gcn}.}

\item{cor_threshold}{Correlation threshold to filter connections.
As a weighted network is a fully connected graph, a cutoff must be selected.
Default is 0.7.}
}
\value{
List containing 1st-order neighbors for each input gene.
}
\description{
Get 1st-order neighbors of a given gene or group of genes
}
\examples{
data(filt.se)
genes <- rownames(filt.se)[1:10]
gcn <- exp2gcn(filt.se, SFTpower = 18, cor_method = "pearson")
neighbors <- get_neighbors(genes, gcn)
}
\seealso{
\code{exp2gcn} \code{SFT_fit}
}
\author{
Fabricio Almeida-Silva
}
