% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.GmtList.R
\name{as.GmtList}
\alias{as.GmtList}
\title{Convert a list of gene symbols into a gmtlist}
\usage{
as.GmtList(list, description = NULL, uniqGenes = TRUE, namespace = NULL)
}
\arguments{
\item{list}{A named list with character vectors of genes. Names will become names of gene sets; character vectors will become genes}

\item{description}{Character, description of gene-sets. The value will be expanded to the same length of the list.}

\item{uniqGenes}{Logical, whether redundant genes should be made unique?}

\item{namespace}{Character or \code{NULL}, namespace of the gene-set}
}
\description{
Convert a list of gene symbols into a gmtlist
}
\examples{
testVec <- list(GeneSet1=c("AKT1", "AKT2"),
               GeneSet2=c("MAPK1", "MAPK3"),
               GeneSet3=NULL)
testVecGmtlist <- as.GmtList(testVec)

}
