% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getReadthrough}
\alias{getReadthrough}
\title{Overlapping Coding Regions}
\source{
Reference GRCh37 genome \url{https://www.gencodegenes.org/human/release_25lift37.html}.
For details on gtf format visit ensemble \url{https://useast.ensembl.org/info/website/upload/gff.html}.
}
\usage{
getReadthrough(gr, cod_gr)
}
\arguments{
\item{gr}{A GRanges object that shows the start and end loci on genome.}

\item{cod_gr}{A GRanges object contaning coding regions.}
}
\value{
A GRanges object that returns overlapping regions of the classified transcript biotypes.
}
\description{
The \code{getReadthrough}() function is used to find long transcripts that cover more
than two coding regions for gene regions of interst.
}
\details{
For details of findOverlaps,  type.partialOverlap, type.50Overlap
type.toPlot, queryhits, readthrough and subjecthits see,
GenomicRanges \url{https://www.bioconductor.org/packages/release/bioc/html/GenomicRanges.html},
IRanges \url{https://www.bioconductor.org/packages/release/bioc/html/IRanges.html},
and BiocManager \url{http://bioconductor.org/install/index.html}.
}
\note{
Replace the path_file when loading data locally to the data directory.
}
\examples{
#First Load datasets and libraries
library(GenomicRanges)
data("gencode")
data("ILEF")
data("cod")

# Assigning datasets a GRanges object
gencode_gr = GRanges(gencode)
ILEF_gr = GRanges(ILEF)
cod_gr = GRanges(cod)

getReadthrough(ILEF_gr,  cod_gr)

\dontrun{getReadthrough(cod_gr)}

}
\references{
Wang,  Z. Z.,  J. M. Cunningham and X. H. Yang (2018).'CisPi: a transcriptomic
score for disclosing cis-acting disease-associated lincRNAs.'
Bioinformatics34(17): 664-670'
}
\author{
Zhezhen Wang and Biniam Feleke
}
