% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{Gene.ID.ann}
\alias{Gene.ID.ann}
\title{Gene.ID.ann: Gene annotation table}
\format{
An object of class \code{data.frame} with 19675 rows and 6 columns.
}
\usage{
data("Gene.ID.ann")
}
\value{
\item{Gene.ID.ann}{Data frame of annotations for GENCODE v27 genes.}
}
\description{
Annotation table for GENCODE Human Release 27 genes (\code{Gene.ID}) used by
StringTie summarisation. Includes HGNC, EntrezGene, and RefSeq identifiers
derived from GENCODE v27 metadata.
}
\details{
Used by internal SSP application functions to translate identifiers prior to
classification with SSP models.
}
\examples{
library(BreastSubtypeR)
data("Gene.ID.ann")
}
\references{
Staaf J, Häkkinen J, Hegardt C, Saal LH, Kimbung S, Hedenfalk I, et al.
RNA sequencing-based single sample predictors of molecular subtype and risk of
recurrence for clinical assessment of early-stage breast cancer.
\emph{NPJ Breast Cancer}. 2022;8(1):27. https://doi.org/10.1038/s41523-022-00465-3
}
\keyword{datasets}
