% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{mod_summary}
\alias{mod_summary}
\alias{mod_summary,CEMiTool-method}
\title{Co-expression module summarization}
\usage{
mod_summary(cem, ...)

\S4method{mod_summary}{CEMiTool}(cem, method = c("mean", "median", "eigengene"), verbose = FALSE)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{method}{A character string indicating which summarization method
is to be used. Can be 'eigengene', 'mean' or 'median'. Default is 'mean'.}

\item{verbose}{Logical. If \code{TRUE}, reports analysis steps.}
}
\value{
A \code{data.frame} with summarized values.
}
\description{
Summarizes modules using mean or eigengene expression.
}
\examples{
# Get example CEMiTool object
data(cem)
# Summarize results
mod_summary <- mod_summary(cem)

}
