% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMPASS.R
\name{COMPASS}
\alias{COMPASS}
\title{Fit the COMPASS Model}
\usage{
COMPASS(
  data,
  treatment,
  control,
  subset = NULL,
  category_filter = function(x) colSums(x > 5) > 2,
  filter_lowest_frequency = 0,
  filter_specific_markers = NULL,
  model = "discrete",
  iterations = 40000,
  replications = 8,
  keep_original_data = FALSE,
  verbose = TRUE,
  dropDegreeOne = FALSE,
  init_with_fisher = FALSE,
  run_model_or_return_data = "run_model",
  ...
)
}
\arguments{
\item{data}{An object of class \code{COMPASSContainer}.}

\item{treatment}{An \R expression, evaluated within the metadata, that
returns \code{TRUE} for those samples that should belong to the
treatment group. For example, if the samples that received a positive
stimulation were named \code{"92TH023 Env"} within a variable in
\code{meta} called \code{Stim}, you could write \code{Stim == "92TH023 Env"}.
The expression should have the name of the stimulation vector on the
left hand side.}

\item{control}{An \R expression, evaluated within the metadata, that
returns \code{TRUE} for those samples that should belong to the
control group. See above for details.}

\item{subset}{An expression used to subset the data. We keep only the samples
for which the expression evaluates to \code{TRUE} in the metadata.}

\item{category_filter}{A filter for the categories that are generated. This is a
function that will be applied to the \emph{treatment counts} matrix generated from
the intensities. Only categories meeting the \code{category_filter} criteria will
be kept.}

\item{filter_lowest_frequency}{A number specifying how many of the least
expressed markers should be removed.}

\item{filter_specific_markers}{Similar to \code{filter_lowest_frequency},
but lets you explicitly exclude markers.}

\item{model}{A string denoting which model to fit; currently, only
the discrete model (\code{"discrete"}) is available.}

\item{iterations}{The number of iterations (per 'replication') to perform.}

\item{replications}{The number of 'replications' to perform. In order to
conserve memory, we only keep the model estimates from the last replication.}

\item{keep_original_data}{Keep the original \code{COMPASSContainer}
as part of the \code{COMPASS} output? If memory or disk space is an issue,
you may set this to \code{FALSE}.}

\item{verbose}{Boolean; if \code{TRUE} we output progress information.}

\item{dropDegreeOne}{Boolean; if \code{TRUE} we drop degree one categories
and merge them with the negative subset.}

\item{init_with_fisher}{Boolean;initialize from fisher's exact test. Any subset and subject with lower 95% log odds estimate >1 will be initialized as a responder.
Otherwise initialize very subject and subset as a responder except those where ps <= pu.}

\item{run_model_or_return_data}{\code{character} defaults to \code{"run_model"} otherwise set it to \code{"return_data"} in order to not fit the model just return the data set needed for modeling. Useful for extracting the boolean counts.}

\item{...}{Other arguments; currently unused.}
}
\value{
A \code{COMPASSResult} is a list with the following components:

\item{fit}{A list of various fitted parameters resulting from the
\code{COMPASS} model fitting procedure.}
\item{data}{The data used as input to the \code{COMPASS} fitting
procedure -- in particular, the counts matrices generated for the
selected categories, \code{n_s} and \code{n_u}, can be extracted
from here.}
\item{orig}{If \code{keep_original_data} was set to \code{TRUE}
in the \code{COMPASS} fit, then this will be the \code{COMPASSContainer}
passed in. This is primarily kept for easier running of the Shiny app.}

The \code{fit} component is a list with the following components:

\item{alpha_s}{The hyperparameter shared across all subjects under the
stimulated condition. It is updated through the \code{COMPASS} model
fitting process.}
\item{A_alphas}{The acceptance rate of \code{alpha_s}, as computed
through the MCMC sampling process in \code{COMPASS}.}
\item{alpha_u}{The hyperparameter shared across all subjects under the
unstimulated condition. It is updated through the \code{COMPASS}
model fitting process.}
\item{A_alphau}{The acceptance rate of \code{alpha_u}, as computed
through the MCMC sampling process in \code{COMPASS}.}
\item{gamma}{An array of dimensions \code{I x K x T}, where \code{I}
denotes the number of individuals, \code{K} denotes the number of
categories / subsets, and \code{T} denotes the number of iterations.
Each cell in a matrix for a given iteration is either zero or one,
reflecting whether individual \code{i} is responding to the stimulation
for subset \code{k}.}
\item{mean_gamma}{A matrix of mean response rates. Each cell denotes
the mean response of individual \code{i} and subset \code{k}.}
\item{A_gamma}{The acceptance rate for the gamma. Each element
corresponds to the number of times an individual's \code{gamma}
vector was updated.}
\item{categories}{The category matrix, showing which categories
entered the model.}
\item{model}{The type of model called.}
\item{posterior}{Posterior measures from the sample fit.}
\item{call}{The matched call used to generate the model fit.}

The \code{data} component is a list with the following components:

\item{n_s}{The counts matrix for stimulated samples.}
\item{n_u}{The counts matrix for unstimulated samples.}
\item{counts_s}{Total cell counts for stimulated samples.}
\item{counts_u}{Total cell counts for unstimulated samples.}
\item{categories}{The categories matrix used to define which
categories will enter the model.}
\item{meta}{The metadata. Note that only \strong{individual-level} metadata
  will be kept; sample-specific metadata is dropped.}
\item{sample_id}{The name of the vector in the metadata used to
identify the samples.}
\item{individual_id}{The name of the vector in the metadata used
to identify the individuals.}

The \code{orig} component (included if \code{keep_original_data} is
\code{TRUE}) is the \code{\link{COMPASSContainer}} object used in the model
fit.
}
\description{
This function fits the \code{COMPASS} model.
}
\section{Category Filter}{

The category filter is used to exclude categories (combinations of
markers expressed for a particular cell) that are expressed very rarely.
It is applied to the \code{treatment} \emph{counts} matrix, which is a
\code{N} samples by \code{K} categories matrix. Those categories which
are mostly unexpressed can be excluded here. For example, the default
criteria,

\code{category_filter=function(x) colSums(x > 5) > 2}

indicates that we should only retain categories for which at least three samples
had at least six cells expressing that particular combination of markers.
}

\examples{
data(COMPASS) ## loads the COMPASSContainer 'CC'
fit <- COMPASS(CC,
  category_filter=NULL,
  treatment=trt == "Treatment",
  control=trt == "Control",
  verbose=FALSE,
  iterations=100 ## set higher for a real analysis
)
}
\seealso{
\itemize{
\item \code{\link{COMPASSContainer}}, for constructing the data object
required by \code{COMPASS}
}
}
