% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeanGammaMulti.R
\name{plotCOMPASSResultStack}
\alias{plotCOMPASSResultStack}
\title{Plot multiple COMPASSResults}
\usage{
plotCOMPASSResultStack(
  x,
  threshold = 0.01,
  minimum_dof = 1,
  maximum_dof = Inf,
  row_annotation,
  variable,
  palette = colorRampPalette(brewer.pal(9, "Purples"))(20),
  show_rownames = FALSE,
  ...
)
}
\arguments{
\item{x}{A named list of objects of class \code{COMPASSResult}. The names are values of type \code{variable}}

\item{threshold}{A numeric threshold for filtering under-expressed
categories. Any categories with mean score < \code{threshold} are
removed.}

\item{minimum_dof}{The minimum degree of functionality for the categories
to be plotted.}

\item{maximum_dof}{The maximum degree of functionality for the categories
to be plotted.}

\item{row_annotation}{A vector of names, pulled from the metadata, to be
used for row annotation.}

\item{variable}{What to call the variable that is different across the objects in x.}

\item{palette}{The colour palette to be used.}

\item{show_rownames}{Boolean; if \code{TRUE} we display row names (ie,
the individual ids).}

\item{...}{Optional arguments passed to \code{pheatmap}.}
}
\value{
The plot as a \code{grid} object (\code{grob}). It can be redrawn
with e.g. \code{grid::grid.draw()}.
}
\description{
This function can be used to visualize the mean probability of response;
that is, the probability that there is a difference in response between
samples subjected to the 'treatment' condition, and samples subjected
to the 'control' condition.
This version is used for plotting multiple COMPASSResult objects.
The COMPASS runs must all use the same markers.
The code is heavily based on the plot.COMPASSResult and plot2 functions.
Not all options from plot.COMPASSResult are supported yet.
}
\examples{
\dontrun{
# allCompassResults is a list of 4 COMPASSResults
names(allCompassResults) <- c("Antigen 85A", "CFP-10", "CMV", "ESAT-6")
plotCOMPASSResultStack(allCompassResults,
    row_annotation = c("Antigen", "PATIENT ID", "Time"),
    variable = "Antigen", show_rownames = FALSE,
    main = "Heatmap of Mean Probability of Response to Antigens, CD8+",
    fontsize = 14, fontsize_row = 13, fontsize_col = 11)
  }
}
