% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_depmap.R
\name{get_depmap_essentiality}
\alias{get_depmap_essentiality}
\title{Get essential/selective gene information from DepMap summary table.}
\usage{
get_depmap_essentiality(gene, depmap.summary)
}
\arguments{
\item{gene}{Character scalar for gene symbol.}

\item{depmap.summary}{data.frame containing DepMap gene summary information.}
}
\value{
Named list containing RNAi and CRISPR named lists containing dataset information for the provided gene,
if available. If the gene is not found in the summary data.frame, the \code{avail} element for the RNAi and CRISPR lists
will be set to \code{FALSE}.
}
\description{
Get essential/selective gene information from DepMap summary table.
}
\examples{
library(CRISPRball)
build_depmap_db(retrieve = "gene.summary")
pool <- pool::dbPool(RSQLite::SQLite(), dbname = "depmap_db.sqlite")
depmap.gene <- pool::dbGetQuery(pool, "SELECT * FROM 'gene.summary'")

essentials <- get_depmap_essentiality(gene = "CDK2", depmap.summary = depmap.gene)
}
\author{
Jared Andrews
}
