% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_gene_sgrna.R
\name{plot_rank}
\alias{plot_rank}
\title{Create an interactive rank plot}
\usage{
plot_rank(
  res,
  ylim = c(-10, 10),
  y.thresh = 0.5,
  y.lines = TRUE,
  hover.info = NULL,
  h.id = "crispr",
  feat.term = "rows",
  sig.term = "fdr",
  rank.term = "LFC",
  rank.ascending = TRUE,
  down.color = "#0026ff",
  up.color = "#ff0000",
  insig.color = "#A6A6A6",
  sig.thresh = 0.05,
  fs = NULL,
  sig.size = 6,
  insig.size = 5,
  sig.opacity = 1,
  insig.opacity = 0.5,
  label.size = 10,
  webgl = TRUE,
  webgl.ratio = 7,
  show.counts = TRUE,
  show.hl.counts = TRUE,
  counts.size = TRUE,
  highlight.featsets = NULL,
  highlight.feats = NULL,
  featsets = NULL,
  highlight.feats.color = "#E69F00",
  highlight.feats.size = 7,
  highlight.feats.opac = 1,
  highlight.feats.linecolor = "#000000",
  highlight.feats.linewidth = 1,
  highlight.feats.label = TRUE,
  highlight.featsets.color = "#009E73",
  highlight.featsets.size = 7,
  highlight.featsets.opac = 1,
  highlight.featsets.linecolor = "#000000",
  highlight.featsets.linewidth = 1,
  highlight.featsets.label = FALSE,
  h.id.suffix = "_rank"
)
}
\arguments{
\item{res}{Dataframe containing, at minimum, significance values and something to rank by (LFC, RRA score, betas, etc).}

\item{ylim}{Numeric vector of length two for the y-axis limits.}

\item{y.thresh}{Numeric scalar used as the y-axis threshold for point coloring.
The negative of this value is also used as the threshold.}

\item{y.lines}{Logical as for whether or not to show horizontal lines at \code{y.thresh}.}

\item{hover.info}{Character vector indicating which additional columns from \code{res}
to include in the hover info.}

\item{h.id}{Character scalar indicating the unique ID of the plotly object. Can usually be ignored,
but should be used if multiple plots are being created in the same R session (e.g. Shiny app).}

\item{feat.term}{Character scalar indicating the column name of the feature IDs in \code{res}.}

\item{sig.term}{Character scalar indicating the column name of the significance values in \code{res}.}

\item{rank.term}{Character scalar for the term to rank by from \code{res}. This will be used as the y-axis.}

\item{rank.ascending}{Boolean indicating whether or not the rank should be ascending.}

\item{down.color}{Character scalar indicating the color of down-regulated features.}

\item{up.color}{Character scalar indicating the color of up-regulated features.}

\item{insig.color}{Character scalar indicating the color of insignificant features.}

\item{sig.thresh}{Numeric scalar indicating the significance threshold for coloring significant features.}

\item{fs}{Dataframe containing coordinates and label information for points that should be labeled.
Columns should be:
\itemize{
\item \code{x} - x coordinate of the point
\item \code{y} - y coordinate of the point
\item \code{customdata} - label to be displayed
}}

\item{sig.size}{Numeric scalar indicating the size of significant feature points.}

\item{insig.size}{Numeric scalar indicating the size of insignificant feature points.}

\item{sig.opacity}{Numeric scalar indicating the opacity of significant feature points.}

\item{insig.opacity}{Numeric scalar indicating the opacity of insignificant feature points.}

\item{label.size}{Numeric scalar indicating the size of feature labels.}

\item{webgl}{Logical indicating whether to use WebGL for rendering the plot.}

\item{webgl.ratio}{Numeric scalar indicating the ratio of WebGL to HTML5 canvas rendering, increases resolution
of saved plot when WebGL plotting is not used.}

\item{show.counts}{Logical indicating whether to show annotations for the number of features in the plot.}

\item{show.hl.counts}{Logical indicating whether to show annotations for the number of highlighted features in the plot.}

\item{counts.size}{Numeric scalar indicating the size of the feature counts labels.}

\item{highlight.featsets}{Character vector indicating which feature sets should be highlighted.}

\item{highlight.feats}{Character vector indicating which features should be highlighted.}

\item{featsets}{Named list of feature sets to be used for highlighting.}

\item{highlight.feats.color}{Character scalar indicating the color of highlighted features.}

\item{highlight.feats.size}{Numeric scalar indicating the size of highlighted features.}

\item{highlight.feats.opac}{Numeric scalar indicating the opacity of highlighted features.}

\item{highlight.feats.linecolor}{Character scalar indicating the line color of highlighted features.}

\item{highlight.feats.linewidth}{Numeric scalar indicating the line width of highlighted features.}

\item{highlight.feats.label}{Logical indicating whether to label highlighted features.}

\item{highlight.featsets.color}{Character scalar indicating the color of highlighted feature sets.}

\item{highlight.featsets.size}{Numeric scalar indicating the point size of highlighted feature sets.}

\item{highlight.featsets.opac}{Numeric scalar indicating the opacity of highlighted feature sets.}

\item{highlight.featsets.linecolor}{Character scalar indicating the line color of highlighted feature sets.}

\item{highlight.featsets.linewidth}{Numeric scalar indicating the line width of highlighted feature sets.}

\item{highlight.featsets.label}{Logical indicating whether to label highlighted feature sets.}

\item{h.id.suffix}{Character scalar indicating the suffix to be added to the plotly object ID.}
}
\value{
An interactive plotly rank plot.
}
\description{
Create an interactive rank plot for data with fold change, significance terms, and rank.
}
\examples{
library(CRISPRball)
d1.genes <- read.delim(system.file("extdata", "esc1.gene_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)
plot.df <- gene_ingress(d1.genes,
    sig.thresh = 0.05, es.thresh = 0.5,
    es.col = "LFC", sig.col = "fdr"
)
plot_rank(plot.df, feat.term = "id")
}
\author{
Jared Andrews
}
