% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansTransform.R
\name{ansTransform}
\alias{ansTransform}
\title{Perform quantification and normalization of count data}
\usage{
ansTransform(countData, noNeg = TRUE, plotDataToPDF = FALSE)
}
\arguments{
\item{countData}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object from \code{\link{getRegionCounts}} with count data.}

\item{noNeg}{A Logical parameter indicating how to deal with negative 
values. 
When TRUE (default), all negative values will be moved to 0 before 
transforming. 
When FALSE, the signs will be maintained while the transformation will be 
applied to the absolute value. (default: TRUE)}

\item{plotDataToPDF}{A logical parameter indicating whether to make plots of the
data distribution to a separate PDF file for each sample.
When TRUE, a histogram will be plotted for the data before and after 
transformation. 
When FALSE, no plots will be made. (default: FALSE)}
}
\value{
A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}} object 
containing the anscombe transformed count data as the assay.
}
\description{
This function quantifies each each region for a sample and performs
background correction and normalization as instructed. 
Returns a vector of count information for the input regions.
}
\examples{
exRange <- GRanges(seqnames=c("chr1","chr2","chr3","chr4"),
ranges=IRanges(start=c(1000,2000,3000,4000),end=c(1500,2500,3500,4500)))
sampleInfo <- read.table(system.file("extdata", "sample_info.txt", 
package="CSSQ",mustWork = TRUE),sep="\\t",header=TRUE)
exCount <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),nrow=4,ncol=4)
exData <- SummarizedExperiment(assays = list(countData=exCount),
rowRanges=exRange,colData=sampleInfo)
ansExData <- ansTransform(exData)
assays(ansExData)$ansCount
}
