% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CT_mean_methylation_in_tissues}
\alias{CT_mean_methylation_in_tissues}
\title{CT genes' promoters mean methylation}
\format{
A \code{SummarizedExperiment} object with 298 rows and 14 columns
\itemize{
\item Rows correspond to CT genes
\item Mean methylation levels in normal tissues are stored in columns
\item CpG densities and results of methylation analysis are stored in
rowData
}
}
\source{
WGBS methylation data was downloaded from Encode and from GEO
databases. Mean methylation levels are evaluated using methylation
values of CpGs located in promoter region (defined as 1000 nt
upstream TSS and 200 nt downstream TSS) (see
\code{scripts/make_CT_mean_methylation_in_tissues.R} for details).
}
\description{
DEPRECATED after v1.5, see \code{mean_methylation_in_tissues}
Mean methylation values of all CpGs located within Cancer-Testis
(CT) promoters in a set of normal tissues
}
\details{
The rowData contains:
\itemize{
\item A column named \code{CpG_density}, gives the density of CpG within
each promoter (number of CpG / promoter length * 100).
\item A column \code{CpG_promoter} that classifies the promoters according
to their CpG densities: "low" (CpG_density < 2), "intermediate"
(CpG_density >= 2 & CpG_density < 4), and "high" (CpG_density >=
4).
\item A column \code{somatic_met_level} that gives the mean methylation
level of each promoter in somatic tissues.
\item A column \code{sperm_met_level} that gives the methylation level of
each promoter in sperm.
\item A column \code{somatic_methylation} indicates if the promoter's mean
methylation level in somatic tissues is higher than 50\%.
\item A column \code{germline_methylation}indicates if the promoter is
methylated in germline, based on the ratio with somatic tissues
(FALSE if somatic_met_level is at least twice higher than
germline_met_level).
}
}
