% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mean_methylation_in_hESC}
\alias{mean_methylation_in_hESC}
\title{All genes' promoters mean methylation in hESC}
\format{
A \code{SummarizedExperiment} object with 24488 rows and 3 columns
\itemize{
\item Rows correspond to all genes (gene names as rownames)
\item Mean methylation levels in hESC types are stored in columns
}
}
\source{
WGBS methylation data was downloaded from Encode. Mean methylation levels are
evaluated using methylation values of CpGs located in promoter region
(defined as 1000 nt upstream TSS and 200 nt downstream TSS) (see
\code{scripts/make_mean_methylation_in_hESC.R} for details).
}
\description{
Mean methylation values of all CpGs located within all genes
promoters in human embryonic stem cells
}
\details{
The rowData contains:
\itemize{
\item A column named \code{ensembl_gene_id} containing gene ids.
}

The colData contains
\itemize{
\item Column \code{genotype} gives the sexual genotype of the cells
}
}
