% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{methylation_in_embryo}
\alias{methylation_in_embryo}
\title{Methylation of CpGs within all genes promoters in embryo}
\format{
A \code{RangedSummarizedExperiment} object with 1915545 rows and 492 columns
\itemize{
\item Rows correspond to CpGs (located within all genes promoters (TSS +- 1000
nt))
\item Columns correspond to cells
\item Methylation values from scWGBS data
\item rowRanges correspond to CpG positions
}
}
\source{
scWGBS methylation data was downloaded from GEO database
(see \code{scripts/make_methylation_in_embryo.R} for details).
}
\description{
Methylation values of CpGs located within all genes
promoters in embryo. Data is based on hg19 reference genome ! From
\verb{Single Cell DNA Methylome Sequencing of Human Preimplantation Embryos} (Zhu et al. 2018)
}
\details{
Description of the colData:
\itemize{
\item Column \code{cell_type} indicates the embryo type.
\item Column \code{bulk_or_single_cell} specifies if the sample was indeed only a
single cell or a bulk of several cells.
\item Other information about the sequencing of each sample are clearly labelled
}
}
