% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{testis_sce}
\alias{testis_sce}
\title{Testis scRNAseq data}
\format{
A \code{SingleCellExperiment} object with 20891 rows and 6490 columns
\itemize{
\item Rows correspond to genes (gene names as rownames)
\item Columns correspond to testis cells
}
}
\source{
The count matrix \code{GSE112013_Combined_UMI_table.txt.gz} was downloaded from
GEO (accession: GSE112013). Metadata correspond to \code{TableS1} from the paper's
supplemental data. The data were converted in a SingleCellExperiment
(see \verb{scripts/13_make_testis_sce.R} for details).
}
\description{
Testis single cell RNAseq data from
\verb{The adult human testis transcriptional cell atlas} (Guo et al. 2018)
}
\details{
Description of the colData:
\itemize{
\item Column \code{nGene} gives the number of distinct genes detected per cell.
\item Column \code{nUMI} gives the total UMI number per cell.
\item Column \code{clusters} gives cluster number defined in the Guo's paper.
\item Column \code{type} gives the testis cell type associated to the cluster number.
\item Column \code{Donor} gives the Donor origin of the cells.
}

Description of the rowData:
\itemize{
\item Column \code{percent_pos_testis_germcells} gives the percent of testis germ cells
in wich the genes are detected (count > 0) (based on testis scRNAseq data).
\item Column \code{percent_pos_testis_somatic} gives the percent of testis somatic cells
in wich the genes are detected (count > 0) (based on testis scRNAseq data).
\item Column\code{testis_cell_type} specifies the testis cell-type showing the highest
mean expression of each gene (based on testis scRNAseq data).
}

The rowData contains the \code{testis_cell_type} column, specifying the testis
cell-type showing the highest mean expression of each gene.
}
