#' Transcriptional Activity of Beta-Catenin in Cancers
#'
#' A vector of continuous scores represents the activation of B-catenin across
#' multiple cancer cell lines
#'
#' @docType data
#'
#' @usage data(CTNBB1_reporter)
#'
#' @format Consists of a vector of continuous scores of B-catenin
#' activity across 82 cancer cell lines. The mutation and copy number 
#' associated with this sample cohorts can be found in 
#' \code{CCLE_MUT_SCNA} dataset.
#' 
#' @return a vector of continuous scores
#' 
#' @references Kim, J., Botvinnik, O., Abudayyeh, O. et al.
#' Characterizing genomic alterations in cancer by complementary
#' functional associations.
#' Nat Biotechnol 34, 539–546 (2016).
#' \href{https://doi.org/10.1038/nbt.3527}{https://doi.org/10.1038/nbt.3527}
#'
"CTNBB1_reporter"
