% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_data_preprocessing.R
\name{readDataSE}
\alias{readDataSE}
\title{Read data stored as an SummarizedExperiment object (directly or stored in an
.rds file).
Extracts the two relevant columns (concentration and measurement) and
orders the data by increasing concentration level.}
\usage{
readDataSE(
  dataPath = NULL,
  rawDataSE = NULL,
  concColName,
  substColName,
  assayNumber = 1,
  rowNumbers = NULL
)
}
\arguments{
\item{dataPath}{\strong{character(1)} \cr Path to the data file (.rds file)}

\item{rawDataSE}{\strong{SummarizedExperiment} \cr SummarizedExperiment object}

\item{concColName}{\strong{character(1)} \cr Name of the column in the colData()
containing the concentration levels.}

\item{substColName}{\strong{character(1)} \cr column name of rowData() containing
the substance name (must be a unique value in each row)}

\item{assayNumber}{\strong{integer(1)} \cr Number of assay to be extracted
from the SummarizedExperiment object}

\item{rowNumbers}{\strong{integer} \cr Row numbers to extract from the
SummarizedExperiment object. Default is NULL, which means that all rows
in the object will be used.}
}
\value{
List of data.frame, each with two numeric columns:
Concentration and Measurement
}
\description{
Read data stored as an SummarizedExperiment object (directly or stored in an
.rds file).
Extracts the two relevant columns (concentration and measurement) and
orders the data by increasing concentration level.
}
\details{
The SummarizedExperiments object may contain quantitative values from
targeted proteomics, lipidomics or metabolomics experiments.
The colData has to contain a column with the concentration levels
(concColName).
The rowData has to contain a column with the substance names (e.g. peptide
sequence, name of lipid or metabolite etc).
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
    package = "CalibraCurve")

D_list <- readDataSE(file,
    concColName = "amount_fmol",
    substColName = "Substance", assayNumber = 1)

# Alternative: import SummarizedExperiment object directly
rawDataSE <- readRDS(file)

D_list2 <- readDataSE(rawDataSE = rawDataSE,
    concColName = "amount_fmol",
    substColName = "Substance", assayNumber = 1
)
}
