% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{getGeneNeighbors}
\alias{getGeneNeighbors}
\title{This function gets the neighbors of a given gene
using either the gene Seurat object or its nearest
neighbor graph returned from getNearestNeighbourLists}
\usage{
getGeneNeighbors(gene, NN)
}
\arguments{
\item{gene}{\itemize{
\item the gene in question
}}

\item{NN}{\itemize{
\item either the gene Seurat object or its nearest
neighbor graph as found by getNearestNeighbourLists.
This can also be a SingleCellExperiment which will be converted
to a Seurat object
}}
}
\value{
the neighboring genes
}
\description{
This function gets the neighbors of a given gene
using either the gene Seurat object or its nearest
neighbor graph returned from getNearestNeighbourLists
}
\examples{
library(Seurat)
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
NN = getExample('NN',toy=TRUE)
neighbors = getGeneNeighbors("Ccl6",STranspose)
neighborsAgain = getGeneNeighbors("Ccl6",NN)
}
