% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNNGraphs.R
\name{getNearestNeighbourLists}
\alias{getNearestNeighbourLists}
\title{This function extracts a shared nearest neighbor network
from a Seurat object}
\usage{
getNearestNeighbourLists(f, graph = defaultGraph(f))
}
\arguments{
\item{f}{\itemize{
\item a Seurat object or SingleCellExperiment to
be converted to a Seurat object
}}

\item{graph}{\itemize{
\item which graph to extract.  Defaults to
paste0(f@active.assay,'_snn')
}}
}
\value{
\itemize{
\item This returns dataframe of neighbors:
nodeA - node names for node A
nodeB - node names for node B
weight - edge weight
}
}
\description{
This function extracts a shared nearest neighbor network
from a Seurat object
}
\examples{
STranspose = make.getExample()('STranspose',toy=TRUE)
NN = getNearestNeighbourLists(STranspose)
}
