% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{nbhdsAsEdgesToNbhdsAsList}
\alias{nbhdsAsEdgesToNbhdsAsList}
\title{nbhdsAsEdgesToNbhdsAsList}
\usage{
nbhdsAsEdgesToNbhdsAsList(cells, neighbourhoods, self = FALSE)
}
\arguments{
\item{cells}{\itemize{
\item The cells whose neighbourhoods to
extract.
}}

\item{neighbourhoods}{\itemize{
\item neighbourhoods given as a
data frame with columns nodeA and nodeB, for example
the output of collapseNeighbourhoods
}}

\item{self}{\itemize{
\item include cell in its neighbourhood, defaults to FALSE
}}
}
\value{
a named list with memberships of the neighbourhoods
of cells
}
\description{
This function takes a set of neighbourhoods given
by edges and turns it into a named list giving the
memberships of each neighbourhood
}
\examples{
delaunayNeighbours = make.getExample()('delaunayNeighbours')
cells = unique(c(delaunayNeighbours[,'nodeA'],delaunayNeighbours[,'nodeB']))
nbhdsList = nbhdsAsEdgesToNbhdsAsList(cells,delaunayNeighbours)
}
