% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{predictAnnotationAllGenes}
\alias{predictAnnotationAllGenes}
\title{This function predicts the functions of all genes based
on the functions of their neighbours.}
\usage{
predictAnnotationAllGenes(
  geneSets,
  fPrime,
  radius,
  metric = "umap",
  normaliseByGeneSet = TRUE,
  normaliseByDistance = TRUE,
  normaliseToUnitVector = TRUE
)
}
\arguments{
\item{geneSets}{\itemize{
\item a set of gene sets, e.g., hallmark
}}

\item{fPrime}{\itemize{
\item a transposed Seurat object (generated with
transposeObject()) or SingleCellExperiment to
be converted to a Seurat object
}}

\item{radius}{\itemize{
\item radius of the region to use for prediction
}}

\item{metric}{\itemize{
\item reduction or NN, defaults to umap
}}

\item{normaliseByGeneSet}{\itemize{
\item normalise by size of each gene set,
defaults to TRUE
}}

\item{normaliseByDistance}{\itemize{
\item attenutate neighbour contributions
based on distance, defaults to TRUE
}}

\item{normaliseToUnitVector}{\itemize{
\item return results as unit
vectors, defaults to TRUE
}}
}
\value{
\itemize{
\item A list where names are genes and values are vectors
of gene annotations whose entries correspond to the geneSets
}
}
\description{
This function predicts the functions of all genes based
on the functions of their neighbours.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark',toy=TRUE)
predictions = predictAnnotationAllGenes(hallmark,STranspose,radius=.5)
}
