% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoodAnalysis.R
\name{runMoransI}
\alias{runMoransI}
\title{This function takes a matrix where rows are features and columns are cells,
and a neighbourhood list, and computes Moran's I.}
\usage{
runMoransI(
  obj,
  spatialGraph,
  assay = "RNA",
  layer = "data",
  nSim = 100,
  verbose = TRUE
)
}
\arguments{
\item{obj}{\itemize{
\item a Seurat object
}}

\item{spatialGraph}{\itemize{
\item a data frame of neighbouring
cell pairs.
}}

\item{assay}{\itemize{
\item assay to pull data from, defaults to RNA.
}}

\item{layer}{\itemize{
\item layer to pull data from, defaults to data.
}}

\item{nSim}{\itemize{
\item number of simulations to perform for p value calculation.
Defaults to 100.
}}

\item{verbose}{\itemize{
\item whether to print trace, defaults to TRUE
}}
}
\value{
a dataframe containing Moran's I and p values for each feature.
}
\description{
This function takes a matrix where rows are features and columns are cells,
and a neighbourhood list, and computes Moran's I.
}
\examples{
getExample = make.getExample()
smallXenium = getExample('smallXenium',toy=TRUE)
delaunayNeighbours = getExample('delaunayNeighbours',toy=TRUE)
moransI = runMoransI(smallXenium, delaunayNeighbours, assay = "SCT", 
layer = "data", nSim = 10, verbose = FALSE)
}
