% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-cure_barcode.R
\name{bc_auto_cutoff}
\alias{bc_auto_cutoff}
\alias{bc_auto_cutoff,BarcodeObj-method}
\title{Finds barcode count cutoff point}
\usage{
bc_auto_cutoff(barcodeObj, useCleanBc = TRUE)

\S4method{bc_auto_cutoff}{BarcodeObj}(barcodeObj, useCleanBc = TRUE)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object.}

\item{useCleanBc}{A logical value, if \code{TRUE}, the \code{cleanBc} slot
in the \code{BarcodeObj} object will be used, otherwise the \code{messyBc}
slot will be used.}
}
\value{
a numeric \code{vector} of the cutoff point.
}
\description{
Finds the cutoff point for the barcode count filtering based on the barcode
count distribution.
}
\details{
The one dimension kmeans clustering is applied to identify the 
"true barcode" based on the read count. The algorithm detail is:
1. Remove the barcodes with counts below the median of counts.
2. Transform the count by log2(x+1).
3. Apply the 1-dimension clustering to the log count, with
the cluster number of 2 and weights of the log count.
4. Choose the minimum count value in the cluster with more counts as
cutoff point.

For more info about 1 dimension kmeans used here please refer to
\code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}.
}
\examples{

data(bc_obj)

bc_auto_cutoff(bc_obj)

}
