% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-extract_barcode.R
\name{bc_extract}
\alias{bc_extract}
\alias{bc_extract,data.frame-method}
\alias{bc_extract,ShortReadQ-method}
\alias{bc_extract,DNAStringSet-method}
\alias{bc_extract,integer-method}
\alias{bc_extract,character-method}
\alias{bc_extract,list-method}
\title{Extract barcode from sequences}
\usage{
bc_extract(
  x,
  pattern = "",
  sample_name = NULL,
  metadata = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{data.frame}(
  x,
  pattern = "",
  sample_name = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{ShortReadQ}(
  x,
  pattern = "",
  sample_name = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{DNAStringSet}(
  x,
  pattern = "",
  sample_name = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{integer}(
  x,
  pattern = "",
  sample_name = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{character}(
  x,
  pattern = "",
  sample_name = NULL,
  metadata = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)

\S4method{bc_extract}{list}(
  x,
  pattern = "",
  sample_name = NULL,
  metadata = NULL,
  maxLDist = 0,
  pattern_type = c(barcode = 1),
  costs = list(sub = 1, ins = 99, del = 99),
  ordered = TRUE
)
}
\arguments{
\item{x}{A single or a list of fastq files, ShortReadQ, DNAStringSet,
data.frame, or named integer.}

\item{pattern}{A string or a string vector with the same number of files,
specifying the regular expression with capture. It matches the barcode (and
UMI) with capture pattern.}

\item{sample_name}{A string vector, applicable when \code{x} is a list or
fastq file vector. This argument specifies the sample names. If not provided,
the function will look for sample names in the rownames of metadata,
the fastqfile name or the \code{list} names.}

\item{metadata}{A \code{data.frame} with sample names as the row names, with 
each metadata record by column, specifying the sample characteristics.}

\item{maxLDist}{An integer. The minimum mismatch threshold for barcode
matching, when maxLDist is 0, the \code{\link[stringr]{str_match}}  is
invoked for barcode matching which is faster, otherwise
\code{\link[utils]{aregexec}} is invoked and the \code{costs} parameters can
be used to specify the weight of the distance calculation.}

\item{pattern_type}{A vector. It defines the barcode (and UMI) capture
group. See Details.}

\item{costs}{A named list, applicable when maxLDist > 0, specifying the
weight of each mismatch event while extracting the barcodes.  The list
element name have to be \code{sub} (substitution), \code{ins} (insertion) and
\code{del} (deletion). The default value is \code{list(sub = 1, ins = 99, del
= 99)}.  See \code{\link[utils]{aregexec}} for more detailed information.}

\item{ordered}{A logical value. If the value is true, the return barcodes
(UMI-barcode tags) are sorted by the read counts.}
}
\value{
This function returns a BarcodeObj object if the input is a \code{list} or a
\code{vector} of Fastq files, otherwise it returns a \code{data.frame.} In
the later case
the \code{data.frame} has columns:
\enumerate{
  \item \code{umi_seq} (optional): UMI sequence, applicable when there is UMI
    in `pattern` and `pattern_type` argument.
  \item \code{barcode_seq}: barcode sequence.
  \item \code{count}: reads number.
}
}
\description{
\code{bc_extract} identifies the barcodes (and UMI) from the sequences using
regular expressions.  \code{pattern} and \code{pattern_type} arguments are
necessary, which provides the barcode (and UMI) pattern and their location
within the sequences.
}
\details{
The \code{pattern} argument is a regular expression, the capture operation
\code{()} identifying the barcode or UMI. \code{pattern_type} argument
annotates capture, denoting the UMI or the barcode captured pattern. In the
example:
\preformatted{
([ACTG]{3})TCGATCGATCGA([ACTG]+)ATCGATCGATC
|---------| starts with 3 base pairs UMI.
           |----------| constant sequence in the backbone.
                       |-------| flexible barcode sequences.
                                |---------| 3' constant sequence.
}

In UMI part \code{[ACGT]{3}}, \code{[ACGT]} means it can be one of
the "A", "C", "G" and "T", and \code{{3}} means it repeats 3 times. 
In the barcode pattern \code{[ACGT]+}, the \code{+} denotes
that there is at least one of the \code{A} or \code{C} or \code{G} or
\code{T.}
}
\examples{
fq_file <- system.file("extdata", "simple.fq", package="CellBarcode")

library(ShortRead)

# barcode from fastq file
bc_extract(fq_file, pattern = "AAAAA(.*)CCCCC")

# barcode from ShortReadQ object
sr <- readFastq(fq_file)  # ShortReadQ
bc_extract(sr, pattern = "AAAAA(.*)CCCCC")

# barcode from DNAStringSet object
ds <- sread(sr)  # DNAStringSet
bc_extract(ds, pattern = "AAAAA(.*)CCCCC")

# barcode from integer vector
iv <- tables(ds, n = Inf)$top # integer vector
bc_extract(iv, pattern = "AAAAA(.*)CCCCC")

# barcode from data.frame 
df <- data.frame(seq = names(iv), freq = as.integer(iv)) # data.frame
bc_extract(df, pattern = "AAAAA(.*)CCCCC")

# barcode from list of DNAStringSet
l <- list(sample1 = ds, sample2 = ds) # list
bc_extract(l, pattern = "AAAAA(.*)CCCCC")

# Extract UMI and barcode
d1 <- data.frame(
    seq = c(
        "ACTTCGATCGATCGAAAAGATCGATCGATC",
        "AATTCGATCGATCGAAGAGATCGATCGATC",
        "CCTTCGATCGATCGAAGAAGATCGATCGATC",
        "TTTTCGATCGATCGAAAAGATCGATCGATC",
        "AAATCGATCGATCGAAGAGATCGATCGATC",
        "CCCTCGATCGATCGAAGAAGATCGATCGATC",
        "GGGTCGATCGATCGAAAAGATCGATCGATC",
        "GGATCGATCGATCGAAGAGATCGATCGATC",
        "ACTTCGATCGATCGAACAAGATCGATCGATC",
        "GGTTCGATCGATCGACGAGATCGATCGATC",
        "GCGTCCATCGATCGAAGAAGATCGATCGATC"
        ),
    freq = c(
        30, 60, 9, 10, 14, 5, 10, 30, 6, 4 , 6
    )
  ) 
# barcode backbone with UMI and barcode
pattern <- "([ACTG]{3})TCGATCGATCGA([ACTG]+)ATCGATCGATC"
bc_extract(
    list(test = d1), 
    pattern, 
    sample_name=c("test"), 
    pattern_type=c(UMI=1, barcode=2))

###
}
