% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{GetGSEAMatrix}
\alias{GetGSEAMatrix}
\title{Get Matrix from Enrichment Results}
\usage{
GetGSEAMatrix(X, metric = "ES")
}
\arguments{
\item{X}{an enrichment results obtained by RunGroupGSEA or RunCellGSEA}

\item{metric}{a character indicating which metric to use as value of matrix (ES, NES, padj, pval)}
}
\value{
A matrix of geneset enrichment metric with cell/group at columns and pathways/genesets at rows
}
\description{
Extract enrcihment score Matrix from RunGSEA functions.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GSEAResults <- RunGroupGSEA(seuratPbmc, Hallmark, group.by = "seurat_clusters", dims = 1:5)
GSEAMatrix <- GetGSEAMatrix(GSEAResults)
}
