% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2gene.R
\name{seq2gene}
\alias{seq2gene}
\title{seq2gene}
\usage{
seq2gene(seq, tssRegion, flankDistance, TxDb, sameStrand = FALSE)
}
\arguments{
\item{seq}{genomic regions in GRanges object}

\item{tssRegion}{TSS region}

\item{flankDistance}{flanking search radius}

\item{TxDb}{TranscriptDb object}

\item{sameStrand}{logical whether find nearest/overlap gene in the same strand}
}
\value{
gene vector
}
\description{
annotate genomic regions to genes in many-to-many mapping
}
\details{
This funciton associates genomic regions with coding genes in a many-to-many mapping. It first maps genomic regions to host genes (either located in exon or intron), proximal genes (located in promoter regions) and flanking genes (located in upstream and downstream within user specify distance).
}
\examples{
\dontrun{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
TxDb <- TxDb.Hsapiens.UCSC.hg19.knownGene
file <- getSampleFiles()[[1]] # a bed file
gr <- readPeakFile(file)
genes <- seq2gene(gr, tssRegion=c(-1000, 1000), flankDistance = 3000, TxDb) 
}
}
\author{
Guangchuang Yu
}
