% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{calculate_gain_or_loss}
\alias{calculate_gain_or_loss}
\title{Estimate the copy gains/loss of tumor vs normal based on log2-ratio of
fraction of reads}
\usage{
calculate_gain_or_loss(scExp, controls, quantiles = c(0.05, 0.95))
}
\arguments{
\item{scExp}{A SingleCellExperiment with "logRatio_cytoBand" reducedDim slot
filled. See  \code{\link{calculate_logRatio_CNA}}}

\item{controls}{Sample IDs or Cell IDs of the normal sample to take as
reference.}

\item{quantiles}{Quantiles of normal log2-ratio distribution below/above
which cytoband is considered to be a loss/gain. (c(0.05,0.95))}
}
\value{
The SCE with the gain or loss in each cytobands
in each cells (of dimension cell x cytoband ) in the  reducedDim
slot "gainOrLoss_cytoBand".
}
\description{
Given a SingleCellExperiment object with the slot "logRatio_cytoBand" containing the
log2-ratio of the fraction of reads in each cytoband, estimate if the
cytoband was lost or acquired a gain in a non-quantitative way. To do so,
the quantiles distribution of the normal cells are calculated, and any
cytoband below or above will be considered as a loss/gain. The False
Discovery Rate is directly proportional to the quantiles.
}
\examples{

data("scExp")
scExp = calculate_cyto_mat(scExp, ref_genome="hg38")
scExp = calculate_logRatio_CNA(scExp, controls=unique(scExp$sample_id)[1])
scExp = calculate_gain_or_loss(scExp, controls=unique(scExp$sample_id)[1])
SingleCellExperiment::reducedDim(scExp, "gainOrLoss_cytoBand")

}
