% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{gene_set_enrichment_analysis_scExp}
\alias{gene_set_enrichment_analysis_scExp}
\title{Runs Gene Set Enrichment Analysis on genes associated with differential
features}
\usage{
gene_set_enrichment_analysis_scExp(
  scExp,
  enrichment_qval = 0.1,
  ref = "hg38",
  GeneSets = NULL,
  GeneSetsDf = NULL,
  GenePool = NULL,
  qval.th = 0.01,
  logFC.th = 1,
  min.percent = 0.01,
  peak_distance = 1000,
  use_peaks = FALSE,
  GeneSetClasses = c("c1_positional", "c2_curated", "c3_motif", "c4_computational",
    "c5_GO", "c6_oncogenic", "c7_immunologic", "hallmark"),
  progress = NULL
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object containing list of differential
features.}

\item{enrichment_qval}{Adjusted p-value threshold for gene set enrichment.
(0.1)}

\item{ref}{A reference annotation, either 'hg38', 'mm10', 'ce11'. ('hg38')}

\item{GeneSets}{A named list of gene sets. If NULL will automatically load
MSigDB list of gene sets for specified reference genome. (NULL)}

\item{GeneSetsDf}{A dataframe containing gene sets & class of gene sets. If
NULL will automatically load MSigDB dataframe of gene sets for specified
reference genome. (NULL)}

\item{GenePool}{The pool of genes to run enrichment in. If NULL will
automatically load Gencode list of genes fro specified reference genome.
(NULL)}

\item{qval.th}{Adjusted p-value threshold to define differential features.
(0.01)}

\item{logFC.th}{Fold change threshold to define differential features. (1)}

\item{min.percent}{Minimum fraction of cells having the feature active to
consider it as significantly differential. (0.01)}

\item{peak_distance}{Maximum distanceToTSS of feature to gene TSS to consider
associated, in bp. (1000)}

\item{use_peaks}{Use peak calling method (must be calculated beforehand).
(FALSE)}

\item{GeneSetClasses}{Which classes of MSIGdb to look for.}

\item{progress}{A shiny Progress instance to display progress bar.}
}
\value{
Returns a SingleCellExperiment object containing list of enriched
Gene Sets for each cluster, either in depleted features, enriched features
or simply differential features (both).
}
\description{
This function takes previously calculated differential features and runs
hypergeometric test to look for enriched gene sets in the genes associated
with differential features, for each cell cluster. This functions takes as
input a SingleCellExperiment object with consclust, the type of comparison,
either 'one_vs_rest' or 'pairwise', the adjusted p-value threshold (qval.th)
and the fold-change threshold (logFC.th). It outputs a SingleCellExperiment
object containing a differential list.
}
\examples{
data("scExp")

#Usually recommanding qval.th = 0.01 & logFC.th = 1 or 2
\dontrun{scExp_cf = gene_set_enrichment_analysis_scExp(scExp,
 qval.th = 0.4, logFC.th = 0.3)}

}
