% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEgenes.R
\name{selectDEgenes}
\alias{selectDEgenes}
\title{selectDEgenes}
\usage{
selectDEgenes(
  sce = NULL,
  de_res = NULL,
  altExp_name = "none",
  pval_adj = 0.05,
  mean_diff = 0,
  pct_diff = 0.1,
  topN = 10
)
}
\arguments{
\item{sce}{A SingleCellExperiment object with DE results stored
in meta data DE_res list.}

\item{de_res}{DE_res returned by DEgenesCross().}

\item{altExp_name}{A character indicates which expression
matrix is used. by default is none (i.e. RNA).}

\item{pval_adj}{A numeric indicates the threshold of adjusted p-value.}

\item{mean_diff}{A numeric indicates the threshold of
difference of average expression.}

\item{pct_diff}{A numeric indicates the threshold of
difference of percentage expression.}

\item{topN}{A numeric indicates the top number of genes
will be included in the list.}
}
\value{
A SingleCellExperiment With filtered DE results in
DE_res_filter list of metadata
}
\description{
A function to select DE genes
}
\examples{
data(sce_control_subset)
sce_control_subset <- DEgenes(sce_control_subset,
group = sce_control_subset$SNF_W_louvain,
return_all = TRUE,
exprs_pct = 0.5)

sce_control_subset <- selectDEgenes(sce_control_subset)

}
