% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_methods.R
\name{correct_IR}
\alias{correct_IR}
\title{Correct gene expression using a linear model}
\usage{
correct_IR(SummarizedCounts = NULL, design = NULL)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{design}{A design matrix with rows corresponding to samples and
columns to coefficients to be estimated. See \code{\link[limma:lmFit]{limma::lmFit()}} and
Law et al. 2020, F1000Research, doi: 10.12688/f1000research.27893.1.}
}
\value{
A numeric matrix of normalized expression values on the log2 scale,
corrected for gDNA contamination, and \code{batch} (if any).
}
\description{
Correct gene expression with IR\% as a co-variate in linear model in the
limma framework.
}
\examples{
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)
assigned_per_region <- get_region_stat(SummarizedCounts = sc)
design = model.matrix(~ group + batch +IR_rate, data = sc$col_data)
ir_corrected <- correct_IR(sc, design)


}
