% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_saf}
\alias{get_saf}
\title{Generate a SAF file for genomic features}
\usage{
get_saf(
  ensdb_sqlite = NULL,
  bamfile = NULL,
  mitochondrial_genome = c("MT", "chrM"),
  chloroplast_genome = c("chrPltd", "Pltd")
)
}
\arguments{
\item{ensdb_sqlite}{A character(1) specifying a path to an SQLite file to
store the an object of the \link[ensembldb:EnsDb-class]{ensembldb::EnsDb} or an object of the
\link[ensembldb:EnsDb-class]{ensembldb::EnsDb}.}

\item{bamfile}{A character(1), a path to a BAM file for the experiment of
interest. The BAM file is used to extract genome information:
chromosome/scaffold names and lengths.}

\item{mitochondrial_genome}{A character(1), mitochondrial genome name in the
EnsDb database (ie, the mitochondrial name in column 1 of the GTF file
used to generate the EnsDb SQLite database).}

\item{chloroplast_genome}{A character(1), chloroplast genome name in the
EnsDb database (ie, the chloroplast name in column 1 of the GTF file
used to generate the EnsDb SQLite database). This is only relevant
for plants.}
}
\value{
A list of data frames containing SAF for genomic features:
genic regions, intergenic regions, exonic regions, intronic regions,
rRNA genes, mitochondrial genome, chloroplast genome (only for plants),
respectively.
\describe{
\item{gene}{a data frame containing a SAF for genes}
\item{exon}{a data frame containing  a SAF for exons}
\item{intergenic_region}{a data frame containing  a SAF for intergenic
regions}
\item{intronic_region}{a data frame containing a SAF for intronic region}
\item{rRNA}{a data frame containing a SAF for rRNA exons}
\item{mitochondrion}{a data frame containing a SAF for the mitochodrion}
\item{chloroplast (optional)}{a data frame containing a SAF for
chloroplast, plnat only}
}
}
\description{
Generate a SAF (simplified annotation format) file for genomic features:
genicregions, intergenic regions, exonic regions, intronic regions, rRNA
genes, mitochondrial genome, and chloroplast genome (only for plants).
}
\examples{
require("ensembldb")
tmp_dir <- tempdir()
gtf <- system.file("extdata", "example.gtf.gz",
                   package = "CleanUpRNAseq")
hs_ensdb_sqlite <-
    ensembldb::ensDbFromGtf(
        gtf = gtf,
        outfile = file.path(tmp_dir, "EnsDb.hs.v110.sqlite"),
        organism = "Homo_Sapiens",
        genomeVersion = "GRCh38",
        version = 110
    )
bam_file <- system.file("extdata", "K084CD7PCD1N.srt.bam",
    package = "CleanUpRNAseq"
)
saf_list <- get_saf(
    ensdb_sqlite = hs_ensdb_sqlite,
    bamfile = bam_file,
    mitochondrial_genome = "MT"
)
}
