% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{processed}
\alias{processed}
\alias{processed,ClustAllObject-method}
\title{Check Processing Status of ClustAllObject}
\usage{
processed(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}
}
\value{
A logical value:
\itemize{
  \item TRUE if \code{\link{runClustAll}} has been executed on the object.
  \item FALSE if the object has not yet been processed by \code{\link{runClustAll}}.
}
}
\description{
This method retrieves the processing status of a ClustAllObject, indicating
whether the ClustALL algorithm has been executed on the object. It provides a
quick way to verify if clustering results are available for analysis.
}
\details{
The processed method serves as a crucial indicator in the ClustALL workflow:

\enumerate{
  \item Processing Status:
  \itemize{
    \item Indicates whether the ClustALL algorithm has been applied to the object.
    \item A TRUE value means clustering results are available for analysis.
    \item A FALSE value indicates the object only contains input data and preprocessing.
  }

  \item Workflow Implications:
  \itemize{
    \item Helps determine which methods and analyses can be performed on the object.
    \item Guides users in the correct sequence of operations in the ClustALL pipeline.
  }

  \item Data Availability:
  \itemize{
    \item TRUE status implies availability of:
    \itemize{
      \item Stratification results (\code{\link{summary_clusters}})
      \item Jaccard distance matrix (\code{\link{JACCARD_DISTANCE_F}})
      \item Other clustering-related outputs
    }
    \item FALSE status means only input and preprocessed data are available.
  }
}
}
\note{
\itemize{
  \item This method checks the 'processed' slot of the ClustAllObject.
  \item The processed status is automatically set to TRUE when \code{\link{runClustAll}}
    completes successfully.
  \item Users should not manually modify this status to ensure consistency between
    the status and the actual content of the object.
  \item A FALSE status does not necessarily indicate an error; it simply means
    \code{\link{runClustAll}} needs to be executed before accessing clustering results.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
obj_noNA <- createClustAll(data = wdbc)
processed(obj_noNA)
}
\seealso{
\code{\link{runClustAll}}, \code{\link{createClustAll}},
\code{\link{ClustAllObject-class}}, \code{\link{summary_clusters}},
\code{\link{JACCARD_DISTANCE_F}}
}
