% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-getGEx-method.R
\name{getGEx,CoSIAn-method}
\alias{getGEx,CoSIAn-method}
\title{getGEx Method}
\usage{
\S4method{getGEx}{CoSIAn}(object)
}
\arguments{
\item{object}{CoSIAn object with all user accessible slots filled with
converted_id slot filled}
}
\value{
CoSIAn Object with gex slot filled
}
\description{
getGEx Method
}
\examples{
Kidney_Genes <- CoSIAn(
    gene_set = c("ENSG00000008710", "ENSG00000118762", "ENSG00000152217"),
    i_species = "h_sapiens", input_id = "Ensembl_id",
    o_species = c(
        "h_sapiens", "r_norvegicus"
    ), output_ids = c("Ensembl_id", "Symbol"),
    mapping_tool = "annotationDBI", ortholog_database = "HomoloGene",
    map_tissues = "heart", map_species = c("r_norvegicus"),
    metric_type = "DS_Gene"
)
Kidney_gene_conversion <- CoSIA::getConversion(Kidney_Genes)
Kidney_gene_gex <- getGEx(Kidney_gene_conversion)
}
